#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef pair<ll, ll> pl;
typedef vector<ll> vl;
typedef vector<pl> vpl;
typedef vector<vpl> vvpl;

#define oo 1e16

ll N, M, K, m, S;
vvpl lst_ady;
vl A, T, F;

void dijkstra(ll vertice, vl &distancia) {
  distancia[vertice] = 0;
  priority_queue<pair<ll,ll>, vector<pair<ll,ll>>, greater<pair<ll,ll>>> min_heap;
  min_heap.push({distancia[vertice], vertice});
  while(!min_heap.empty()) {
    auto [distancia_enfrente, enfrente] = min_heap.top();
    min_heap.pop();
    if(distancia_enfrente > distancia[enfrente]) continue;
    for(auto [vecino, peso_vecino]: lst_ady[enfrente]) {
      if(distancia[vecino] > distancia_enfrente + peso_vecino) {
        distancia[vecino] = distancia_enfrente + peso_vecino;
        min_heap.push({distancia[vecino], vecino});
      }
    }
  }
}

int main () {
  cin >> N >> M >> K >> m >> S;
  lst_ady.resize(N);
  A.resize(K+1);
  T.resize(N);
  F.resize(S);
  
  for(ll i = 0; i < M; ++i) {
    ll u, v, w;
    cin >> u >> v >> w;
    u--, v--;
    lst_ady[u].push_back({v, w});
    lst_ady[v].push_back({u, w});
  }
  for(auto &e: T)
    cin >> e;
  for(auto &e: A)
    cin >> e;
  for(auto &e: F)
    cin >> e;

  vl disL(N, oo);
  vl disR(N, oo);
  bool usadoL = false, usadoR = false;
  if(m > 1) {
    usadoL = true;
    dijkstra(A[m-2] - 1, disL);
  }
  if(m < K+1) {
    usadoR = true;
    dijkstra(A[m] - 1, disR);
  }

  ll eleccion_min_ruta = -1;
  ll suma_min_ruta = oo;
  for(auto e: F) {
    e--;
    ll pos_res = T[e];
    pos_res += (usadoL) ? disL[e]: 0;
    pos_res += (usadoR) ? disR[e]: 0;
    if(suma_min_ruta >= pos_res) {
      suma_min_ruta = pos_res;
      eleccion_min_ruta = e+1;
    }
  }
  cout << eleccion_min_ruta << '\n';

  return 0;
}
