/*
Deseo ante todo expresar a mis conciudadanos que los últimos treinta años de mi vida los consagré exclusivamente al altruismo y al efecto hice mi primer testamento en 1894, legando a la sociedad de Valparaíso una Universidad, pero en el transcurso del tiempo, la experiencia me demostró que aquello era un error y que era de importancia capital levantar al proletario de mi patria, concibiendo un plan, por el cual contribuyo, primeramente con mi óbolo a la infancia, enseguida a la Escuela Primaria, de ella a la Escuela de Artes y Oficios y por último al Colegio de Ingenieros, poniendo al alcance del desvalido meritorio llegar al más alto grado del saber humano.
*/

#include <bits/stdc++.h>
#include <queue>
using namespace std;

template< typename T >
ostream& operator<<(ostream& os, const set< T > &s);
template< typename T, typename T2 >
ostream& operator<<(ostream& os, const pair< T, T2 > &p);
template< typename T >
ostream& operator<<(ostream& os, const vector< T > &vec);
template< typename T, typename T2 >
ostream& operator<<(ostream& os, const map< T, T2 > &m);

template< typename T >
ostream& operator<<(ostream& os, const set< T > &s) {
  os << "{";
  for(uint64_t i = 0; i < s.size(); i++) {
    os << s[i];
    if(i != s.size() - 1)
      os << ", ";
  }
  os << "}";
  return os;
}

template< typename T, typename T2 >
ostream& operator<<(ostream& os, const pair< T, T2 > &p) {
  os << "(" << p.first << "," << p.second << ")";
  return os;
}

template< typename T >
ostream& operator<<(ostream& os, const vector< T > &vec) {
  os << "[";
  for(uint64_t i = 0; i < vec.size(); i++) {
    os << vec[i];
    if(i != vec.size() - 1)
      os << ", ";
  }
  os << "]";
  return os;
}

template< typename T, typename T2 >
ostream& operator<<(ostream& os, const map< T, T2 > &m) {
  os << "{";
  for(auto p : m) {
    os << "(" << p.first << "," << p.second << ")";
    os << " ";
  }
  os << "}";
  return os;
}

#define dbg(var) cout << #var << " = " << var << "\n";
#define ll long long
#define graph vector< vector< pair< ll, ll > > >
#define vll vector< ll >

int main() {
#ifndef debug
  ios_base::sync_with_stdio(false);
  cin.tie(NULL);
  cout.setf(ios::fixed);
  cout.precision(4);
#endif
  int t = 1;
  while(t--) {
    ll N, M, k, m, s;
    cin >> N >> M >> k >> m >> s;

    graph g(N);

    for(int i = 0; i < M; i++) {
      ll a, b, w;
      cin >> a >> b >> w;
      b--; a--;
      g[a].push_back({b, w});
      g[b].push_back({a, w});
    }

    vll t(N);
    for(int i = 0; i < N; i++) cin >> t[i];

    vll h(k + 1);
    for(int i = 0; i < k + 1; i++) {
      cin >> h[i];
      h[i]--;
    }
    h[m - 1]++;

    vll fh(s);
    for(int i = 0; i < s; i++) {
      cin >> fh[i];
      fh[i]--;
    }

    vll ds1(N, 1000000000000000);
    vll ds2(N, 1000000000000000);

    auto dijkstra = [&] (int s, vll &ds) {
      priority_queue< pair< ll, ll >, vector< pair< ll, ll > >, greater<pair<ll, ll>>> pq;
      pq.push({0, s});
      ds[s] = 0;

      while(pq.size() > 0) {
        auto [d, n] = pq.top();
        pq.pop();

        if(d > ds[n]) continue;

        for(int i = 0; i < g[n].size(); i++) {
          ll v, w;
          v = g[n][i].first;
          w = g[n][i].second;
          if(w + d < ds[v]) {
            ds[v] = d + w;
            pq.push({ds[v], v});
          }
        }
      }
    };

    if(m == 1) { // caso casa inicial
      dijkstra(h[m], ds1);

      ll min_i, min_w;
      min_i = -1;
      min_w = 1000000000000000;
      for(int i = 0; i < s; i++) {
        if(t[fh[i]] + ds1[fh[i]] < min_w) {
          min_i = fh[i];
          min_w = t[fh[i]] + ds1[fh[i]];
        }
      }

      cout << min_i + 1 << "\n";

    } else if(m == k + 1) { // caso casa final
      dijkstra(h[m - 2], ds1);

      ll min_i, min_w;
      min_i = -1;
      min_w = 1000000000000000;
      for(int i = 0; i < s; i++) {
        if(t[fh[i]] + ds1[fh[i]] < min_w) {
          min_i = fh[i];
          min_w = t[fh[i]] + ds1[fh[i]];
        }
      }

      cout << min_i + 1 << "\n";
    } else {
      dijkstra(h[m - 2], ds1);
      dijkstra(h[m], ds2);

      ll min_i, min_w;
      min_i = -1;
      min_w = 1000000000000000;
      for(int i = 0; i < s; i++) {
        if(ds1[fh[i]] + t[fh[i]] + ds2[fh[i]] < min_w) {
          min_i = fh[i];
          min_w = ds1[fh[i]] + t[fh[i]] + ds2[fh[i]];
        }
      }

      cout << min_i + 1 << "\n";
    }
  }
  return 0;
}
