/*
Deseo ante todo expresar a mis conciudadanos que los últimos treinta años de mi vida los consagré exclusivamente al altruismo y al efecto hice mi primer testamento en 1894, legando a la sociedad de Valparaíso una Universidad, pero en el transcurso del tiempo, la experiencia me demostró que aquello era un error y que era de importancia capital levantar al proletario de mi patria, concibiendo un plan, por el cual contribuyo, primeramente con mi óbolo a la infancia, enseguida a la Escuela Primaria, de ella a la Escuela de Artes y Oficios y por último al Colegio de Ingenieros, poniendo al alcance del desvalido meritorio llegar al más alto grado del saber humano.
*/

#include <bits/stdc++.h>
using namespace std;

template< typename T >
ostream& operator<<(ostream& os, const set< T > &s);
template< typename T, typename T2 >
ostream& operator<<(ostream& os, const pair< T, T2 > &p);
template< typename T >
ostream& operator<<(ostream& os, const vector< T > &vec);
template< typename T, typename T2 >
ostream& operator<<(ostream& os, const map< T, T2 > &m);

template< typename T >
ostream& operator<<(ostream& os, const set< T > &s) {
  os << "{";
  for(uint64_t i = 0; i < s.size(); i++) {
    os << s[i];
    if(i != s.size() - 1)
      os << ", ";
  }
  os << "}";
  return os;
}

template< typename T, typename T2 >
ostream& operator<<(ostream& os, const pair< T, T2 > &p) {
  os << "(" << p.first << "," << p.second << ")";
  return os;
}

template< typename T >
ostream& operator<<(ostream& os, const vector< T > &vec) {
  os << "[";
  for(uint64_t i = 0; i < vec.size(); i++) {
    os << vec[i];
    if(i != vec.size() - 1)
      os << ", ";
  }
  os << "]";
  return os;
}

template< typename T, typename T2 >
ostream& operator<<(ostream& os, const map< T, T2 > &m) {
  os << "{";
  for(auto p : m) {
    os << "(" << p.first << "," << p.second << ")";
    os << " ";
  }
  os << "}";
  return os;
}

#define dbg(var) cout << #var << " = " << var << endl;
#define SIZE 2000001
#define BPW 64
#define SIZE_BV SIZE / BPW + 1
#define WPB 64
#define SIZE_RANK SIZE_BV / WPB + 1

int print_bv(long long* bv) {
  for(int i = 0; i < SIZE_BV; i++)
    if(bv[i / BPW] & (1LL << (i % BPW))) cout << i << " ";
  cout << endl;
  return 1;
}

int print_array(long long* arr, int n) {
  for(int i = 0; i < n; i++)
    cout << arr[i] << " ";
  cout << endl;
  return 1;
}

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(NULL);
  cout.setf(ios::fixed);
  cout.precision(4);
  int n, q;
  cin >> n >> q;
  
  unsigned long long bv[SIZE_BV];
  for(int i = 0; i < SIZE_BV; i++) bv[i] = 0;

  for(int i = 0; i < n; i++) {
    long long x;
    cin >> x;
    bv[x / BPW] |= (1LL << (x % BPW));
  }

  //print_bv(bv);
  long long prefix[SIZE_RANK];

  for(int i = 0; i < SIZE_RANK; i++) prefix[i] = 0;

  long long sum = 0;
  int i;
  for(i = 0; i < SIZE; i += BPW) {
    if(i % (BPW * WPB) == 0) {
      prefix[i / (BPW * WPB)] = sum;
    }
    sum += __builtin_popcountll(bv[i / BPW]);
  }
  //print_array(prefix, 5);

  for(int i = 0; i < q; i++) {
    int a;
    cin >> a;
    int block = a / (BPW * WPB);
    int ans = prefix[block];
    int pos = block * (WPB * BPW);
    for(; pos + BPW < a; pos += BPW) {
      ans += __builtin_popcountll(bv[pos / BPW]);
    }

    for(; pos < a; pos++) {
      ans += (bv[pos / BPW] & (1LL << (pos % BPW))) > 0 ? 1 : 0;
    }
    cout << ans << "\n";
  }

  return 0;
}
