#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

#define repx(i, a, b) for (int i = a; i < int(b); i++)
#define rep(i, n) repx(i, 0, n)
#define invrepx(i, a, b) for (int i = b; i-- > int(a);)
#define invrep(i, n) invrepx(i, 0, n)

const double EPS = 1e-9;
// solve a system of equations.
// complexity: O(min(N, M) * N * M)
// `a` is a list of rows
// the last value in each row is the result of the equation
// return values:
//  0 -> no solutions
//  1 -> unique solution, stored in `ans`
// -1 -> infinitely many solutions, one of which is stored in `ans`
int gauss(vector<vector<double>> a, vector<double> &ans) {
  int N = a.size(), M = a[0].size() - 1;
  vector<int> where(M, -1);
  for (int j = 0, i = 0; j < M && i < N; j++) {
    int sel = i;
    repx(k, i, N) if (abs(a[k][j]) > abs(a[sel][j])) sel = k;
    if (abs(a[sel][j]) < EPS)
      continue;
    repx(k, j, M + 1) swap(a[sel][k], a[i][k]);
    where[j] = i;
    rep(k, N) if (k != i) {
      double c = a[k][j] / a[i][j];
      repx(l, j, M + 1) a[k][l] -= a[i][l] * c;
    }
    i++;
  }
  ans.assign(M, 0);
  int k = -1;
  rep(i, M) if (where[i] == -1) {
    ans[i] = 1.0;
    k = i;
    break;
  }
  assert(k != -1);
  rep(j, M) if (where[j] != -1) {
    // ans[j] * a[where[j]][j] + ans[k] * a[where[j]][k] = 0
    ans[j] = -a[where[j]][k] / a[where[j]][j];
  }
  return -1;
}

int main() {
  int N;
  cin >> N;
  vector<vector<double>> M(N, vector<double>(N + 3));
  rep(i, N + 2) rep(j, N) cin >> M[j][i];

  M.push_back(vector<double>(N + 3, 1.0));
  M.back()[N + 2] = 0;
  vector<double> X(N + 2);
  gauss(M, X);

  double sm = 0;
  rep(i, N + 2) if (X[i] >= 0) sm += X[i];
  assert(sm > 0);

  rep(i, N + 2) cout << (X[i] >= 0 ? 'A' : 'B');
  cout << endl;
  rep(i, N + 2) cout << fixed << setprecision(7) << abs(X[i]) / sm << endl;
}
