#include <bits/stdc++.h>

using namespace std;

int main(){
  ios_base::sync_with_stdio(0); cin.tie(0);

  int n;
  cin >> n;

  vector <vector<pair<int,int>>> adj(n);
  vector <tuple<int,int,string,int>> boxes(n);
  for(int i=0; i<n; i++){
    int x, y;
    string d;
    cin >> x >> y >> d;
    boxes[i] = {x,y,d,i};
  }

  // laseres verticales
  sort(boxes.begin(), boxes.end());
  for(int i=1; i<n; i++){
    auto [x1,y1,d1,u] = boxes[i-1];
    auto [x2,y2,d2,v] = boxes[i];
    if(x1 == x2){
      adj[u].push_back({v, d1!="arriba"});
      adj[v].push_back({u, d2!="abajo"});
    }
  }
  // laseres horizontales
  sort(boxes.begin(), boxes.end(), [&](auto t1, auto t2){
       auto [x1,y1,d1,u] = t1;
       auto [x2,y2,d2,v] = t2;
       if(y1==y2) return x1<x2;
       return y1<y2;
  });
  for(int i=1; i<n; i++){
    auto [x1,y1,d1,u] = boxes[i-1];
    auto [x2,y2,d2,v] = boxes[i];
    if(y1 == y2){
      adj[u].push_back({v, d1!="derecha"});
      adj[v].push_back({u, d2!="izquierda"});
    }
  }

  using ii = pair<int,int>;
  const int INF = 1e9;
  vector <int> dist(n, INF);
  deque <int> dq;
  dist[0] = 0;
  dq.push_back(0);

  while(!dq.empty()){
    auto u = dq.front();
    dq.pop_front();

    for(auto [v, w] : adj[u]){
      if(dist[u]+w < dist[v]){
        dist[v] = dist[u]+w;
        if(w == 0){
          dq.push_front(v);
        }
        else{
          dq.push_back(v);
        }
      }
    }
  }

  if(dist[n-1] == INF) dist[n-1] = -1;
  cout << dist[n-1] << '\n';
}
